﻿/* Publication */
var Publication = {

    /* Color Section */
    ColorSection: function (_this) {
        var rgb = 0;

        rgb = $(_this).css("color");
        rgb = rgb.match(/^rgb\((\d+),\s*(\d+),\s*(\d+)\)$/);

        $(_this).find("div").css("color", (rgb[1] * 299 + rgb[2] * 587 + rgb[3] * 114) / 1000 >= 128 ? "Black" : "White");
    },

    /* Color Setter */
    ColorSetter: function (selector, value) {
        $(selector).spectrum({
            showPalette: true,
            showSelectionPalette: true,
            palette: [],
            maxSelectionSize: 50,
            showButtons: false,
            color: value,
            change: function (color) {
                $(selector + " div").css("backgroundColor", color.toHexString());
                $(selector).attr("data-color", color.toHexString());
            },
            localStorageKey: "publication.colors"
        });
    },

    /* Repository Publication */
    SetRepositoryPublication: function (_this) {
        var information = {
            _this: $(_this),
            selector: $("#ui-dialog-container-sections"),
            loading: $(_this).closest(".ui-dialog-content")
        };

        var data = {
            sectionId: $(_this).attr("data-attribute-id")
        };

        var callBack = {
            before: function () { },
            after: function () { }
        };

        Ajax.Loading(information, data, callBack);
    },

    /* Status */
    SetPublicationStatus: function (_this) {
        var information = {
            _this: $(_this),
            selector: $(_this),
            loading: $(_this).closest(".ui-dialog-content")
        };

        var data = {
            id: $(_this).attr("data-attribute-id")
        };

        var callBack = {
            before: function () { },
            after: function () { }
        };

        Ajax.Loading(information, data, callBack);
    },

    /* Href */
    SetRepositoryPublicationHref: function (event, _this) {
        event.preventDefault();

        $(_this).attr("data-action", "RepositorySection");

        Publication.SetRepositoryPublication(_this);
    }
};