﻿$(document).ready(function () {
    Functions = {
        DiagramZoom: function (diagram, delta) {
            let zoom = delta < 0 ? 0.1 : -0.1;

            if ($(diagram).data("zoom") < 4 && zoom > 0 || $(diagram).data("zoom") > 0.2 && zoom < 0) {
                $(diagram).data("zoom", $(diagram).data("zoom") + zoom);

                let eaWidth = $(diagram).data("eawidth") / 100;
                let eaHeight = $(diagram).data("eaheight") / 100;

                $(diagram).attr("width", $(diagram).data("diagramwidth") / eaWidth * $(diagram).data("zoom"));
                $(diagram).attr("height", $(diagram).data("diagramheight") / eaHeight * $(diagram).data("zoom"));

                $(diagram).closest(".draggable").find(".diagramMap").each(function (i) {
                    $(this).css("left", $(this).data("diagramleft") / eaWidth * $(diagram).data("zoom"));
                    $(this).css("top", $(this).data("diagramtop") / eaHeight * $(diagram).data("zoom"));

                    $(this).css("width", $(this).data("diagramwidth") / eaWidth * $(diagram).data("zoom"));
                    $(this).css("height", $(this).data("diagramheight") / eaHeight * $(diagram).data("zoom"));
                });
            }
        },

        Tabs: {
            SetActive: function (tab, controller, action) {
                var finalObject = [];
                var data = JSON.parse(localStorage.getItem("EaInfoportT3.Tabs"));

                if (data !== null) {
                    $.each(data, function (key, val) {
                        if (controller === val.controller && action === val.action) {
                            data[key] = null;
                        } else {
                            finalObject.push({
                                controller: val.controller,
                                action: val.action,
                                tab: val.tab
                            });
                        }
                    });
                }

                finalObject.push({
                    controller: controller,
                    action: action,
                    tab: tab.attr("href").replace("#", "")
                });

                localStorage.setItem("EaInfoportT3.Tabs", JSON.stringify(finalObject));
            },

            GetActive: function (controller, action) {
                var data = JSON.parse(localStorage.getItem("EaInfoportT3.Tabs"));

                if (data !== null) {
                    $.each(data, function (key, val) {
                        if (controller === val.controller && action === val.action) {
                            $("ul.nav-tabs > li").removeClass("active");
                            $("div.tab-content > div").removeClass("active").removeClass("in");

                            $("ul.nav-tabs > li").find("a[href=\"#" + val.tab + "\"]").closest("li").addClass("active");
                            $("div.tab-content > div#" + val.tab).addClass("active").addClass("in");

                            $("ul.nav-tabs > li").find("a[href=\"#" + val.tab + "\"]").closest("li").closest("div.tab-pane").each(function () {
                                $(this).addClass("active").addClass("in");
                                $(this).parent().parent().find("ul.nav-tabs > li").find("a[href=\"#" + $(this).attr("id") + "\"]").closest("li").addClass("active");
                            });
                        }
                    });
                }

                if ($(".tab-pane.active").length === 0) {
                    $(".tab-content > div.tab-pane:first").each(function () {
                        $(this).addClass("active").addClass("in");
                        $(this).parent().parent().find("ul.nav-tabs > li").find("a[href=\"#" + $(this).attr("id") + "\"]").closest("li").addClass("active");
                    });
                }
            }
        }
    };
});